package com.framsticks.params.types;

import com.framsticks.params.CastFailure;
import com.framsticks.params.ParamBuilder;
import com.framsticks.params.PrimitiveParam;
import com.framsticks.params.ReassignResult;
import com.framsticks.util.lang.Numbers;

import javax.annotation.concurrent.Immutable;

/**
 * @author Piotr Sniegowski
 */
@Immutable
public class BinaryParam extends PrimitiveParam<Integer> {

	/**
	 * @param builder
	 */
	public BinaryParam(ParamBuilder builder) {
		super(builder);
	}

	@Override
	public Class<?> getStorageType() {
		return Integer.class;
	}

	@Override
	public String getFramsTypeName() {
		return "db";
	}

	@Override
	public ReassignResult<?> reassign(Object newValue, Object oldValue) throws CastFailure {
		if (newValue instanceof String) {
			Integer v = Numbers.parse((String) newValue, Integer.class);
			if (v != null) {
				return ReassignResult.create(v);
			}
			throw new CastFailure();
		}
		if (newValue instanceof Integer) {
			return ReassignResult.create((Integer) newValue);
		}
		throw new CastFailure();
	}

}
