package com.framsticks.params.types;

import com.framsticks.params.Access;
import com.framsticks.params.ArrayListAccess;
import com.framsticks.params.CastFailure;
import com.framsticks.params.ParamBuilder;
import com.framsticks.params.ReassignResult;
import com.framsticks.util.lang.Casting;
import com.framsticks.util.lang.Numbers;

import java.util.List;

import javax.annotation.concurrent.Immutable;

/**
 * @author Piotr Sniegowski
 */
@Immutable
public class ArrayListParam extends ListParam {

	public ArrayListParam(ParamBuilder builder) {
		super(builder);
	}


	@Override
	public Class<?> getStorageType() {
		return List.class;
	}

	@Override
	public Access prepareAccess(Access access) {
		return new ArrayListAccess(access);
	}

	@Override
	public String computeAccessId() {
		return "l " + containedTypeName;
	}

	@Override
	public ReassignResult<List<?>> reassign(Object newValue, Object oldValue) throws CastFailure {
		if (newValue == null) {
			throw new CastFailure();
		}
		Integer size = Numbers.cast(newValue, Integer.class);
		if (size != null) {
			//return oldValue;
			// List<?> list;
			// if (oldValue == null) {
			//	list = new ArrayList<Object>();
			// } else {
			//	list = Casting.tryCast(List.class, oldValue);
			//	if (list == null) {
			//		throw new CastFailure();
			//	}
			// }
			// Containers.resizeList(list, size);
			return new ReassignResult<List<?>>(Casting.tryCast(List.class, oldValue));
			// return new ReassignResult<List<?>>(list);
		}
		// if (oldValue != null) {
		//	return new ReassignResult<List<?>>(Casting.throwCast(List.class, oldValue));
		// }
		return new ReassignResult<List<?>>(Casting.throwCast(List.class, newValue));
	}

	@Override
	public String getFramsTypeName() {
		return "l " + getContainedTypeName();
	}

		// return (value == null) ? "0" : Integer.toString(Casting.throwCast(List.class, value).size());
}
