package com.framsticks.params;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

import com.framsticks.structure.messages.ListChange;

public class SimpleUniqueList<T extends UniqueObject> implements Iterable<T> {

	protected final Map<String, T> children;
	protected final Class<T> type;
	protected final char prefix;
	protected final EventListeners<ListChange> listeners = new EventListeners<>();

	protected int counter = 0;

	/**
	 * @param type
	 */
	public SimpleUniqueList(Class<T> type, char prefix) {
		this.type = type;
		this.prefix = prefix;
		children = UniqueListAccess.createMap(type, this);
	}

	// public static <T2> SimpleUniqueList<T2> make(Class<T2> type) {
	//	return new SimpleUniqueList<T2>(type);
	// }

	public String generateId() {
		return prefix + Integer.toString(counter++);
	}

	@Override
	public Iterator<T> iterator() {
		return children.values().iterator();
	}

	public void addListener(EventListener<ListChange> listener) {
		listeners.add(listener);
	}

	public void removeListener(EventListener<ListChange> listener) {
		listeners.remove(listener);
	}

	public void fireChildrenChange(ListChange original, ListChange.Action action, Object... hints) {
		listeners.actionForAll(new ListChange(action, original.getPosition(), original.getIdentifier(), hints));

	}

	public void fireChildrenChange(T child, ListChange.Action action, Object... hints) {
		ListChange change = new ListChange(action, UniqueListAccess.getNumberInMap(children, child), child.getUid(), hints);
		listeners.actionForAll(change);
	}

	public void add(T child) {
		child.setUid(generateId());
		children.put(child.getUid(), child);
		fireChildrenChange(child, ListChange.Action.Add);
	}

	public void remove(T child) {
		fireChildrenChange(child, ListChange.Action.Remove);
		children.remove(child.getUid());
	}

	public void modify(T child) {
		fireChildrenChange(child, ListChange.Action.Modify);
	}

	public Map<String, T> getView() {
		return Collections.unmodifiableMap(children);
	}

	public Map<String, T> getMap() {
		return children;
	}
}
