package com.framsticks.params;

public class ReassignResult<T> {
	protected final T value;
	protected final int flags;

	/**
	 * @param value
	 * @param state
	 */
	public ReassignResult(T value, int state) {
		this.value = value;
		this.flags = state;
	}

	/**
	 * @param value
	 */
	public ReassignResult(T value) {
		this.value = value;
		this.flags = 0;
	}

	/**
	 * @return the value
	 */
	public final T getValue() {
		return value;
	}

	/**
	 * @return the state
	 */
	public final int getFlags() {
		return flags;
	}

	public static <T> ReassignResult<T> create(T value) {
		return new ReassignResult<T>(value);
	}

}
