package com.framsticks.params;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;

@FramsClassAnnotation
public abstract class ParamsPackage {


	protected boolean build = false;

	public abstract void register(Registry registry);

	/**
	 * @return the build
	 */
	@ParamAnnotation
	public boolean getBuild() {
		return build;
	}

	/**
	 * @param build the build to set
	 */
	@ParamAnnotation
	public void setBuild(boolean build) {
		this.build = build;
	}

	protected void register(Registry registry, Class<?> javaClass) {
		if (build) {
			registry.registerAndBuild(javaClass);
		} else {
			registry.register(javaClass);
		}
	}

}
