package com.framsticks.params;

public class OpaqueObject {

	protected final String typeName;
	protected final long address;

	/**
	 * @param typeName
	 * @param address
	 */
	public OpaqueObject(String typeName, long address) {
		this.typeName = typeName;
		this.address = address;
	}

	@Override
	public String toString() {
		return typeName + "<0x" + Long.toHexString(address) + ">";
	}

	/**
	 * @return the typeName
	 */
	public String getTypeName() {
		return typeName;
	}

	/**
	 * @return the address
	 */
	public long getAddress() {
		return address;
	}

	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof OpaqueObject)) {
			return false;
		}
		OpaqueObject opaque = (OpaqueObject) obj;
		return typeName.equals(opaque.getTypeName()) && address == opaque.getAddress();
	}

	@Override
	public int hashCode() {
		return typeName.hashCode() ^ new Long(address).hashCode();
	}
}
