package com.framsticks.params;

import com.framsticks.structure.messages.Message;

public class MessageLogger extends EventListeners<Message> {

	protected String className;

	public MessageLogger() {
		this(MessageLogger.class);
	}

	public MessageLogger(Class<?> ownerClass) {
		className = ownerClass.getSimpleName();
	}

	public void info(String function, String message) {
		if (!listeners.isEmpty()) {
			actionForAll(new Message(className, function, message, 0));
		}
	}

}
