package com.framsticks.params;

import java.util.LinkedList;
import java.util.List;

/**
 * @author Piotr Sniegowski
 */
public class ListSink implements Sink {
	protected final List<String> out;
	protected StringBuilder lineBuilder = new StringBuilder();

	public ListSink(List<String> out) {
		this.out = out;
	}

	public ListSink() {
		this.out = new LinkedList<String>();
	}

	public final List<String> getOut() {
		return out;
	}


	@Override
	public Sink print(String str) {
		lineBuilder.append(str);
		return this;
	}

	@Override
	public Sink print(Object obj) {
		lineBuilder.append(obj);
		return this;
	}

	@Override
	public void breakLine() {
		out.add(lineBuilder.toString());
		lineBuilder = new StringBuilder();
	}

	@Override
	public void close() {
	}
}
