package com.framsticks.params;

import java.util.ArrayList;
import java.util.List;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.Builder;

@FramsClassAnnotation(id = "group", name = "group")
public class GroupBuilder implements Builder<Group> {

	@ParamAnnotation
	protected String name;

	protected final List<Param> params = new ArrayList<Param>();

	public GroupBuilder() {
	}

	@ParamAnnotation
	public GroupBuilder name(String name) {
		this.name = name;
		return this;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return the params
	 */
	public List<Param> getParams() {
		return params;
	}

	public Group finish() {
		return new Group(this);
	}

	public void addParam(Param param) {
		params.add(param);
	}


}
