package com.framsticks.model.f0;

import java.util.Arrays;
import java.util.List;

import com.framsticks.model.ModelPackage;
import com.framsticks.params.FramsClassBuilder;
import com.framsticks.params.GroupBuilder;
import com.framsticks.params.ParamBuilder;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.parsers.XmlLoader;
import com.framsticks.util.AutoBuilder;
import com.framsticks.util.ResourceBuilder;

@FramsClassAnnotation
public class SchemaBuilder extends ResourceBuilder<Schema> implements AutoBuilder {

	@Override
	public Schema finish() {

		if (stream == null) {
			stream(Schema.getDefaultDefinitionAsStream());
		}

		XmlLoader xmlLoader = new XmlLoader();
		xmlLoader.setUseLowerCase(true);
		xmlLoader.getRegistry()
			.registerAndBuild(Schema.class)
			.registerAndBuild(FramsClassBuilder.class)
			.registerAndBuild(NeuroClassBuilder.class)
			.registerAndBuild(ParamBuilder.class)
			.registerAndBuild(NeuroParamBuilder.class)
			.registerAndBuild(GroupBuilder.class)
			;

		new ModelPackage().register(xmlLoader.getRegistry());

		Schema schema = xmlLoader.load(Schema.class, stream);
		new ModelPackage().register(schema.getRegistry());
		return schema;
	}

	@Override
	public List<Object> autoFinish() {
		Schema result = finish();
		return Arrays.asList((Object) result);
	}

}
