package com.framsticks.model.f0;

import com.framsticks.params.FramsClassBuilder;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;

@FramsClassAnnotation(id = "neuroclass", name = "neuroclass")
public class NeuroClassBuilder extends FramsClassBuilder {

	/**
	 *
	 */
	public NeuroClassBuilder() {
		super();
	}

	protected Integer preferredInputs;

	protected Integer preferredOutput;

	protected Integer preferredLocation;

	protected Integer visualHints;

	protected String symbolGlyph;

	/** That method is just an alias needed by f0def.xml in current shape.
	 *
	 */
	@ParamAnnotation(id = "description")
	public NeuroClassBuilder descriptionAlias(String description) {
		description(description);
		return this;
	}

	/** That method is just an alias needed by f0def.xml in current shape.
	 *
	 */
	@ParamAnnotation(id = "description")
	public String descriptionAlias() {
		return description;
	}

	@Override
	public NeuroClass finish() {
		return new NeuroClass(this);
	}

	/**
	 * @return the preferredInputs
	 */
	@ParamAnnotation(id = "inputs")
	public Integer getPreferredInputs() {
		return preferredInputs;
	}

	/**
	 * @param preferredInputs the preferredInputs to set
	 */
	@ParamAnnotation(id = "inputs")
	public void setPreferredInputs(Integer preferredInputs) {
		this.preferredInputs = preferredInputs;
	}

	/**
	 * @return the preferredOutput
	 */
	@ParamAnnotation(id = "output")
	public Integer getPreferredOutput() {
		return preferredOutput;
	}

	/**
	 * @param preferredOutput the preferredOutput to set
	 */
	@ParamAnnotation(id = "output")
	public void setPreferredOutput(Integer preferredOutput) {
		this.preferredOutput = preferredOutput;
	}

	/**
	 * @return the preferredLocation
	 */
	@ParamAnnotation(id = "location")
	public Integer getPreferredLocation() {
		return preferredLocation;
	}

	/**
	 * @param preferredLocation the preferredLocation to set
	 */
	@ParamAnnotation(id = "location")
	public void setPreferredLocation(Integer preferredLocation) {
		this.preferredLocation = preferredLocation;
	}

	/**
	 * @return the visualHints
	 */
	@ParamAnnotation(id = "visualhints")
	public Integer getVisualHints() {
		return visualHints;
	}

	/**
	 * @param visualHints the visualHints to set
	 */
	@ParamAnnotation(id = "visualhints")
	public void setVisualHints(Integer visualHints) {
		this.visualHints = visualHints;
	}

	/**
	 * @return the symbolGlyph
	 */
	@ParamAnnotation(id = "symbol")
	public String getSymbolGlyph() {
		return symbolGlyph;
	}

	/**
	 * @param symbolGlyph the symbolGlyph to set
	 */
	@ParamAnnotation(id = "symbol")
	public void setSymbolGlyph(String symbolGlyph) {
		this.symbolGlyph = symbolGlyph;
	}


}
