package com.framsticks.model;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;

@FramsClassAnnotation
public class World {

	@ParamAnnotation(id = "wrldbnd")
	public int boundaries;

	@ParamAnnotation(id = "wrldwat")
	public double waterLevel;


	@ParamAnnotation(id = "wrldtyp")
	public int type;

	@ParamAnnotation(id = "wrldsiz")
	public double size;

	@ParamAnnotation(id = "wrldmap")
	public String map;

	@ParamAnnotation(id = "wrldg")
	public double gravity;

	@ParamAnnotation(id = "simtype")
	public int simulationEngine;

	@ParamAnnotation(id = "nnspeed")
	public double neuralNetworkSimulationSpeed;

	@ParamAnnotation
	public String faces;
	/*
	public static ReflectionAccess createReflection()
	{
		return ReflectionAccess.create(new World(),
				"World, 1, 3, World",
				"wrldbnd, 0, 0, World boundary, d, 0",
				"wrldwat, 0, 0, World water, f, 0",
				"faces, 0, 0, Faces, s, 0"
			);
	}
	*/
}
