package com.framsticks.model;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.math.Point3d;

/**
 * @author Piotr Sniegowski
 */
@FramsClassAnnotation
public class Neuro extends BaseNeuro {

	@ParamAnnotation
	public int channelCount;

	@ParamAnnotation
	public double inputSum;

	@ParamAnnotation
	public double weightedInputSum;

	@ParamAnnotation
	public double state;

	@ParamAnnotation(id = "currState")
	public double currentState;

	@ParamAnnotation
	public boolean hold;

	@ParamAnnotation
	public double position_x, position_y, position_z;

	public Point3d getPosition() { return new Point3d(position_x, position_y, position_z); }
	public void setPosition(Point3d p) { position_x = p.x; position_y = p.y; position_z = p.z; }

}
