package com.framsticks.model;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;

import java.util.ArrayList;
import java.util.List;

/**
 * Author: Piotr Śniegowski
 */
@FramsClassAnnotation(id = "m")
public class Model implements ModelComponent {

	@ParamAnnotation(id = "se")
	public double startingEnergy;

	@ParamAnnotation
	public double getEnerg0() { return startingEnergy; }
	@ParamAnnotation
	public void setEnerg0(double energ0) { startingEnergy = energ0; }


	@ParamAnnotation(id = "Vstyle")
	public String visualizationStyle;

	@ParamAnnotation
	public final List<Part> parts = new ArrayList<Part>();

	@ParamAnnotation
	public final List<Joint> joints = new ArrayList<Joint>();

	@ParamAnnotation(id = "neurodefs")
	public final List<NeuroDefinition> neuroDefinitions = new ArrayList<NeuroDefinition>();

	@ParamAnnotation(id = "neuroconns")
	public final List<NeuroConnection> neuroConnections = new ArrayList<NeuroConnection>();

	/** Those methods accept doubles to keep consistency with Framsticks server.*/
	@ParamAnnotation
	public double getNumparts() { return (double)parts.size(); }
	@ParamAnnotation
	public double getNumjoints() { return (double)joints.size(); }
	@ParamAnnotation
	public double getNumneurons() { return (double)neuroDefinitions.size(); }

	//this is impossible to use, because numparts field is marked as readonly
	@ParamAnnotation
	public void setNumparts(double numparts) {}
	@ParamAnnotation
	public void setNumjoints(double numjoints) {}
	@ParamAnnotation
	public void setNumneurons(double numneurons) {}

	public List<Part> getParts() { return parts; }
	public List<Joint> getJoints() { return joints; }
	public List<NeuroDefinition> getNeuroDefinitions() { return neuroDefinitions; }
	public List<NeuroConnection> getNeuroConnections() { return neuroConnections; }

	@Override
	public String toString() {
		return "Model{" + parts.size() + ":" + joints.size() + ":" + neuroDefinitions.size() + ":" + neuroConnections.size() + "}";

	}

}
