package com.framsticks.model;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;


// import org.apache.logging.log4j.Logger;

@FramsClassAnnotation
public class Genotype extends Model {
	// private final static Logger log = LogManager.getLogger(Genotype.class);

	@ParamAnnotation
	public String name;

	@ParamAnnotation
	public String genotype;

	@ParamAnnotation
	public String info;

	@ParamAnnotation(id = "simi")
	public double similarity;

	@ParamAnnotation(id = "numconnections")
	public double brainConnections;

	@ParamAnnotation(id = "num")
	public int ordinalNumber;

	@ParamAnnotation(id = "gnum")
	public int generation;

	@ParamAnnotation
	public int instances;

	@ParamAnnotation(id = "lifespan")
	public double lifeSpan;

	@ParamAnnotation
	public double velocity;

	@ParamAnnotation
	public double distance;

	@ParamAnnotation(id = "vertvel")
	public double verticalVelocity;

	@ParamAnnotation(id = "vertpos")
	public double verticalPosition;

	@ParamAnnotation(id = "fit")
	public double fitness;

	@ParamAnnotation(id = "fit2")
	public double finalFitness;

	@ParamAnnotation(id = "f0genotype")
	public String genotypeInF0;

	@ParamAnnotation(id = "convtrace1")
	public String conversionBacktrace;

	@ParamAnnotation
	public boolean isValid;

	public Object[] userFields = new Object[3];
	@ParamAnnotation
	public Object getUser1() { return userFields[0]; }
	@ParamAnnotation
	public void setUser1(Object user1) { userFields[0] = user1; }

	@ParamAnnotation
	public Object getUser2() { return userFields[1]; }
	@ParamAnnotation
	public void setUser2(Object user2) { userFields[1] = user2; }

	@ParamAnnotation
	public Object getUser3() { return userFields[2]; }
	@ParamAnnotation
	public void setUser3(Object user3) { userFields[2] = user3; }

	@ParamAnnotation
	public String uid;

	@ParamAnnotation
	public double getStrsiz() { return getNumparts(); }
	@ParamAnnotation
	public void setStrsiz(double strsiz) {}


	@ParamAnnotation
	public double getStrjoints() { return getNumjoints(); }
	@ParamAnnotation
	public void setStrjoints(double strjoints) {}


	@ParamAnnotation
	public double getNnsiz() { return getNumneurons(); }
	@ParamAnnotation
	public void setNnsiz(double nnsiz) {}


	@ParamAnnotation
	public double getNncon() { return brainConnections; }
	@ParamAnnotation
	public void setNncon(double nncon) { this.brainConnections = nncon; }

	@ParamAnnotation
	public int getPopsiz() { return instances; }
	@ParamAnnotation
	public void setPopsiz(int popsiz) { this.instances = popsiz; }

	@Override
	public String toString() {
		return name;
	}

}

