package com.framsticks.hosting;

import com.framsticks.params.EventListener;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.params.types.EventParam;
import com.framsticks.params.types.ProcedureParam;
import com.framsticks.structure.Path;
import com.framsticks.util.dispatching.Future;
import com.framsticks.util.dispatching.ThrowExceptionHandler;

@FramsClassAnnotation
public class CliEvent {

	protected Cli cli;
	protected String id;

	protected Path path;
	protected EventParam param;

	protected String name;
	protected String pathToEvent;

	protected EventListener<Object> listener;

	public CliEvent() {
	}

	@ParamAnnotation(paramType = ProcedureParam.class)
	public void remove() {
		assert path.getTree().isActive();

		//it should happen now
		path.getTree().removeListener(path, param, listener, Future.doNothing(Void.class, ThrowExceptionHandler.getInstance()));
		cli.events.remove(id);
	}

	/**
	 * @return the id
	 */
	@ParamAnnotation
	public String getId() {
		return id;
	}

	@ParamAnnotation
	public String getUid() {
		return id;
	}

	@ParamAnnotation
	public String getName() {
		return name;
	}

	@Override
	public String toString() {
		return "event " + id + " of type " + param + " in " + path;
	}

}
