package com.framsticks.gui.table;

import com.framsticks.gui.controls.ProcedureControl;
import com.framsticks.params.CompositeParam;
import com.framsticks.params.types.ProcedureParam;
import com.framsticks.structure.Path;

import static com.framsticks.params.ParamsUtil.arguments;

public class ProcedureColumn extends Column {

	public ProcedureColumn(ProcedureParam param, TableModel tableModel) {
		super(param, tableModel);
	}

	@Override
	public ProcedureParam getParam() {
		return (ProcedureParam) param;
	}

	@Override
	public Class<?> getColumnClass() {
		return ProcedureParam.class;
	}

	@Override
	public Object getValueAt(int rowIndex) {
		return param;
	}

	@Override
	public int setValueAt(int rowIndex, Object value) {
		CompositeParam param = tableModel.getAccess().getCompositeParam(rowIndex);
		if (param == null) {
			return 0;
		}
		Path path = tableModel.getListPanel().getCurrentPath().appendParam(param).tryFindResolution();
		if (!path.isResolved()) {
			return 0;
		}
		ProcedureControl.callProcedure(path, getParam(), arguments(), tableModel.getFrame());
		return 0;
	}

	@Override
	public boolean isEditable() {
		return true;
	}

}
