package com.framsticks.gui.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.lang.Delimeted;

@FramsClassAnnotation
public class ColumnsConfig {

	protected final List<String> columnsNames = new ArrayList<>();

	protected String className;

	@ParamAnnotation(id = "columnsNames")
	public void setColumnsNamesAsString(String columns) {
		columnsNames.clear();
		columnsNames.addAll(Arrays.asList(columns.split(" ")));
	}

	@ParamAnnotation(id = "columnsNames")
	public String getColumnsNamesAsString() {
		return new Delimeted<String>(" ", "").append(columnsNames.iterator()).build();
	}

	/**
	 * @return the columnsNames
	 */
	public List<String> getColumnsNames() {
		return columnsNames;
	}

	/**
	 * @return the name
	 */
	@ParamAnnotation
	public String getClassName() {
		return className;
	}

	/**
	 * @param name the name to set
	 */
	@ParamAnnotation
	public void setClassName(String className) {
		this.className = className;
	}

	@Override
	public String toString() {
		return "columns config for " + className + ": " + getColumnsNames();
	}


}
