package com.framsticks.gui.controls;

import javax.swing.text.JTextComponent;

import com.framsticks.params.PrimitiveParam;

@SuppressWarnings("serial")
public abstract class TextOnlyControl extends TextControl {

	public TextOnlyControl(PrimitiveParam<?> valueParam) {
		super(valueParam);
	}

	protected abstract JTextComponent getTextComponent();

	@Override
	public void pushValueToUserInterfaceImpl(Object text) {
		getTextComponent().setText(getParam().serialize(text));
	}

	@Override
	public Object pullValueFromUserInterface() {
		return getTextComponent().getText();
	}
}
