package com.framsticks.gui.controls;

import com.framsticks.gui.Gui;
import com.framsticks.params.PrimitiveParam;

import javax.swing.*;
import javax.swing.text.JTextComponent;

import java.awt.*;

@SuppressWarnings("serial")
public class TextFieldControl extends TextOnlyControl {


	private static final Color WRONG_COLOR = new Color(255, 180, 215);

	protected final JTextField textField;
	private final Color correctColor;

	@Override
	protected boolean notifyOfChange() {
		boolean result = super.notifyOfChange();
		textField.setBackground(result ? correctColor : WRONG_COLOR);
		return result;
	}

	public TextFieldControl(PrimitiveParam<?> valueParam) {
		super(valueParam);
		textField = new JTextField();
		textField.setName("value");
		correctColor = textField.getBackground();

		textField.setMinimumSize(new Dimension(0, Control.LINE_HEIGHT));
		this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Control.LINE_HEIGHT));

		addDefaultDocumentListener(textField);

		Gui.addLeftToLabel(this, textField);
	}


	@Override
	protected JTextComponent getTextComponent() {
		return textField;
	}

	@Override
	protected void updateEnabled(boolean enabled) {
		textField.setEnabled(enabled);
	}

}
