package com.framsticks.gui.controls;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

import com.framsticks.params.PrimitiveParam;

@SuppressWarnings("serial")
public abstract class TextControl extends ValueControl {

	public TextControl(PrimitiveParam<?> valueParam) {
		super(valueParam);
	}

	protected void addDefaultDocumentListener(JTextComponent text) {
		text.getDocument().addDocumentListener(createDocumentListener(new Runnable() {
			@Override
			public void run() {
				notifyOfChange();
			}
		}));
	}

	protected static DocumentListener createDocumentListener(final Runnable runnable) {
		return new DocumentListener() {
			@Override
			public void insertUpdate(DocumentEvent documentEvent) {
				runnable.run();
			}

			@Override
			public void removeUpdate(DocumentEvent documentEvent) {
				runnable.run();
			}

			@Override
			public void changedUpdate(DocumentEvent documentEvent) {
				runnable.run();
			}
		};
	}



}
