package com.framsticks.gui.controls;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBox;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.gui.Gui;
import com.framsticks.params.types.BooleanParam;

@SuppressWarnings("serial")
public class CheckBoxControl extends ValueControl {

	private static final Logger log = LogManager.getLogger(CheckBoxControl.class.getName());

	protected final JCheckBox checkBox;

	public CheckBoxControl(BooleanParam booleanParam) {
		super(booleanParam);
		checkBox = new JCheckBox();
		checkBox.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent actionEvent) {
				log.debug("change to: {}", checkBox.isSelected());
				notifyOfChange();
			}
		});
		this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Control.LINE_HEIGHT));
		Gui.addLeftToLabel(this, checkBox);
	}

	@Override
	public void pushValueToUserInterfaceImpl(Object value) {
		if (value == null) {
			return;
		}
		checkBox.setSelected((Boolean) value);
	}

	@Override
	public Object pullValueFromUserInterface() {
		return checkBox.isSelected();
	}

	@Override
	public BooleanParam getParam() {
		return (BooleanParam) param;
	}

	@Override
	protected void updateEnabled(boolean enabled) {
		checkBox.setEnabled(enabled);
	}

}
