package com.framsticks.gui.console;

import com.framsticks.communication.File;
import com.framsticks.util.FramsticksException;
// import org.apache.logging.log4j.Logger;

// import java.awt.Color;

import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;

/**
 * Class paints messages.
 */
public class ConsolePainter {
	// private static final Logger log = LogManager.getLogger(ConsolePainter.class.getName());

	private final Document doc;
	private final JTextPane textPane;
	// private Color c1 = new Color(192, 0, 0);
	// private Color c2 = new Color(84, 141, 212);
	// private Color c3 = new Color(118, 146, 60);
	// private Color c4 = new Color(0, 0, 128);
	// private final SimpleLinePainter linePainter1;
	// private final SimpleLinePainter linePainter2;
	private final SimpleAttributeSet set = new SimpleAttributeSet();


	/**
	 * Constructor sets reference to pane with text.
	 * @param pane Pane where text is displaying.
	 */
	public ConsolePainter(JTextPane pane) {
		this.textPane = pane;
		doc = textPane.getStyledDocument();
		// linePainter1 = new SimpleLinePainter(textPane, new Color(224, 224, 255));
		// linePainter2 = new SimpleLinePainter(textPane, new Color(240, 240, 255));
	}

	/**
	 * Paints message.
	 */
	public void paintMessage(File file) {


		String line;
		// Boolean boldNextId = false;
		// Boolean doNotPaint = false;

		while ((line = file.getContent().readLine()) != null) {
			paintLine(line + "\n");
			/*
			if (doNotPaint) {
				plainText(line);
				if (line.endsWith("~\n")) {
					doNotPaint = false;
				}
				continue;
			}

			int indColon = line.indexOf(':');

			if (indColon == -1) {
				String word = firstWord(line);
				String rest = line.substring(word.length());
				Color col = c1;

				if (word.startsWith("ok")) {
					col = Color.BLACK;
				} else if (word.startsWith("error")) {
					col = Color.RED;
				}

				paintLine(word, col, "b");
				paintLine(rest, Color.BLACK, "b");
				continue;
			}

			if (indColon == line.length() - 2) {
				String before = line.substring(0, indColon);
				String type = "b";

				if (before.equals("class")) {
					boldNextId = true;
				}

				paintLine(before + ":", c2, type);
				paintLine("\n", Color.BLACK, "");
				continue;
			}
			String before = line.substring(0, indColon);
			String after = line.substring(indColon + 1);

			String type;

			if (before.equals("id") && boldNextId) {
				type = "b";
				boldNextId = false;
			} else {
				type = "";
			}

			paintLine(before + ":", c3, "b");
			paintLine(after, Color.BLACK, type);

			if (after.startsWith("~")) {
				doNotPaint = true;
			}*/

		}

		scrollDown();

	}

	private void paintLine(String text) {
		//TODO colouring output, maybe using parsers?
		try {
			doc.insertString(doc.getLength(), text, set);
		} catch (BadLocationException e) {
			throw new FramsticksException().msg("failed document insertion").cause(e);
		}
	}
	/**
	 * Paints line of text.
	 * @param text Line of text to be painted.
	 * @param color Font color.
	 * @param type Font attributes [b|i|u] (bold | italic | underline)
	 */
	/*
	private void paintLine(String text, Color color, String type) {
		SimpleAttributeSet set = new SimpleAttributeSet();

		if (type.contains("b")) {
			StyleConstants.setBold(set, true);
		}

		if (type.contains("i")) {
			StyleConstants.setItalic(set, true);
		}

		if (type.contains("u")) {
			StyleConstants.setUnderline(set, true);
		}

		StyleConstants.setFontFamily(set, "Monospaced");
		StyleConstants.setForeground(set, color);
		textPane.setCharacterAttributes(set, true);

		try {
			doc.insertString(doc.getLength(), text, set);
		} catch (BadLocationException e) {
			e.printStackTrace();
		}

	}
	*/



	/**
	 * Returns first word in text line.
	 * @param line Line of text.
	 * @return First word in text line (with space char).
	 */
	// private String firstWord(String line) {
	// 	String result;
	// 	int spaceIndex = line.indexOf(' ');

	// 	if (spaceIndex == -1) {
	// 		result = line;
	// 	} else {
	// 		result = line.substring(0, spaceIndex + 1);
	// 	}

	// 	return result;
	// }

	/**
	 * Paint line as plain text.
	 * @param msg
	 */
	/*
	private void plainText(String msg) {
		paintLine(msg, Color.BLACK, "");
	}
	*/

	/**
	 * Adds message typed by user.
	 * @param msg Message typed by user.
	 */
	public void userLine(String line) {
		// paintLine("[USER]> "/*, c4, "b"*/);
		scrollDown();
		// linePainter1.resetHighlight();
		paintLine(line);
		paintLine("\n");
		scrollDown();
	}

	/**
	 * Scrolling text pane.
	 */
	private void scrollDown() {
		// textPane.setCaretPosition(doc.getLength() - 1);
	}

}
