package com.framsticks.gui.configuration;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;

/**
 * Class stores information about user favourite node or field.
 */
@FramsClassAnnotation
public class UserFavourite {

	/**
	 * Name of node/field.
	 */
	protected String name;

	/**
	 * Path to node/field.
	 */
	protected String path;

	/**
	 * Field name - property getId or group name if node is group;
	 */
	protected String fieldId;

	public UserFavourite() {
	}

	@ParamAnnotation
	public String getPath() {
		return path;
	}

	/**
	 * @param path the path to set
	 */
	@ParamAnnotation
	public void setPath(String path) {
		this.path = path;
	}

	/**
	 * @param fieldId the fieldId to set
	 */
	@ParamAnnotation
	public void setFieldId(String fieldId) {
		this.fieldId = fieldId;
	}

	@ParamAnnotation
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	@ParamAnnotation
	public void setName(String name) {
		this.name = name;
	}

	@ParamAnnotation
	public String getFieldId() {
		return fieldId;
	}
}
