package com.framsticks.gui;

import static com.framsticks.structure.TreeOperations.*;

import com.framsticks.gui.tree.AbstractNode;
import com.framsticks.gui.tree.TreeNode;
import com.framsticks.params.Access;
import com.framsticks.params.CompositeParam;
import com.framsticks.params.FramsClass;
import com.framsticks.structure.Path;
import com.framsticks.structure.Tree;
import com.framsticks.util.lang.Casting;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

@SuppressWarnings("serial")
public abstract class TreePanel extends AbstractPanel {

	private static final Logger log = LogManager.getLogger(TreePanel.class);

	@Override
	public void fillPanelWith(AbstractNode node) {
		TreeNode treeNode = Casting.throwCast(TreeNode.class, node);

		Path path = Path.to(treeNode.getTree(), treeNode.getTextual());
		if (!path.isResolved()) {
			log.error("path is not resolved: {}", path);
			return;
		}
		setCurrentPath(path);
		pullValuesFromLocalToUser(bindAccess(path));
	}

	public static class Parameters {
		public final TreeAtFrame treeAtFrame;
		public final CompositeParam param;

		/** Contained type FramsClass. */
		public final FramsClass framsClass;

		public Parameters(TreeAtFrame treeAtFrame, CompositeParam param, FramsClass framsClass) {
			this.treeAtFrame = treeAtFrame;
			this.param = param;
			this.framsClass = framsClass;
		}
	}

	protected final TreeAtFrame treeAtFrame;
	protected final String className;
	protected final FramsClass framsClass;
	protected final CompositeParam param;
	protected Path currentPath;

	public TreePanel(Parameters parameters) {
		super(parameters.treeAtFrame.getFrame());
		this.treeAtFrame = parameters.treeAtFrame;
		this.framsClass = parameters.framsClass;
		this.param = parameters.param;
		this.className = parameters.param.getContainedTypeName();
		this.setName(parameters.param.getFramsTypeName());
		log.debug("created panel: {}", this);
	}

	/**
	 * @return the currentTreePath
	 */
	public Path getCurrentPath() {
		return currentPath;
	}

	/**
	 * @param currentTreePath the currentTreePath to set
	 */
	public void setCurrentPath(Path path) {
		path.assureResolved();
		this.currentPath = path;
	}

	public final TreeAtFrame getTreeAtFrame() {
		return treeAtFrame;
	}
	public final Object getCurrentObject() {
		assert currentPath != null;
		return currentPath.getTopObject();
	}
	public final Tree getTree() {
		assert currentPath != null;
		return currentPath.getTree();
	}

	public final String getClassName() {
		return className;
	}

	public abstract void pullValuesFromLocalToUser(Access access);

	@Override
	public String toString() {
		return param.getFramsTypeName() + "(" + uniqueName + ")";
	}

}
