package com.framsticks.gui;


import com.framsticks.util.dispatching.AbstractJoinable;
import com.framsticks.util.dispatching.Dispatcher;
import com.framsticks.util.dispatching.ThrowExceptionHandler;

import javax.swing.*;
import com.framsticks.util.dispatching.RunAt;

/**
 * @author Piotr Sniegowski
 */
public class SwingDispatcher<C> extends AbstractJoinable implements Dispatcher<C> {

	@SuppressWarnings("rawtypes")
	protected static final SwingDispatcher instance = new SwingDispatcher();

	@SuppressWarnings("unchecked")
	public static <C> Dispatcher<C> getInstance() {
		return (Dispatcher<C>) instance;
	}

	public SwingDispatcher() {
		dispatch(new RunAt<C>(ThrowExceptionHandler.getInstance()) {
			@Override
			protected void runAt() {
				Thread.currentThread().setName("gui");
			}
		});
	}

	@Override
	public final boolean isActive() {
		return SwingUtilities.isEventDispatchThread();
	}

	@Override
	public final void dispatch(RunAt<? extends C> runnable) {
		SwingUtilities.invokeLater(runnable);
	}

	@Override
	public String getName() {
		return "gui";
	}

	@Override
	protected void joinableStart() {

	}

	@Override
	protected void joinableInterrupt() {
		finishJoinable();
	}

	@Override
	protected void joinableFinish() {

	}

	@Override
	protected void joinableJoin() throws InterruptedException {

	}

}
