package com.framsticks.gui;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;


import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import static com.framsticks.structure.TreeOperations.*;

/**
 * @author Piotr Sniegowski
 */
@SuppressWarnings("serial")
public abstract class ModifiablePanel extends TreePanel {

	private static final Logger log = LogManager.getLogger(ModifiablePanel.class.getName());

	/**
	 * Pane to which components will be added.
	 */

	protected final JLabel label;
	protected final JButton applyButton;
	protected final JButton revertButton;
	protected final JPanel centerPanel;

	protected Component contentComponent;

	public ModifiablePanel(TreePanel.Parameters parameters) {
		super(parameters);
		log.debug("create panel for type: {}", className);

		JPanel pageEndPanel = new JPanel();
		pageEndPanel.setLayout(new BoxLayout(pageEndPanel, BoxLayout.X_AXIS));
		pageEndPanel.add(Box.createHorizontalGlue());

		applyButton = new JButton("Apply");
		applyButton.setName("apply");

		revertButton = new JButton("Revert");
		revertButton.setName("revert");

		pageEndPanel.add(applyButton);
		pageEndPanel.add(Box.createHorizontalStrut(10));

		pageEndPanel.add(revertButton);
		pageEndPanel.add(Box.createHorizontalStrut(10));

		pageEndPanel.setPreferredSize(new Dimension(0, 30));

		applyButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				applyChanges();
			}
		});

		revertButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				revertChanges();
			}
		});

		label = new JLabel();
		centerPanel = new JPanel();
		centerPanel.setLayout(new BorderLayout());
		centerPanel.add(Box.createHorizontalStrut(10), BorderLayout.LINE_START);
		centerPanel.add(Box.createHorizontalStrut(10), BorderLayout.LINE_END);
		centerPanel.add(label, BorderLayout.PAGE_START);


		centerPanel.add(pageEndPanel, BorderLayout.PAGE_END);

		this.setLayout(new BorderLayout());
		this.add(centerPanel, BorderLayout.CENTER);
		//this.add(new ViewerTest(), BorderLayout.PAGE_END);
	}

	protected abstract void applyChanges();
	protected abstract void revertChanges();

	protected void setupContentComponent(Component contentComponent) {
		this.contentComponent = contentComponent;
		centerPanel.add(contentComponent, BorderLayout.CENTER);
	}

	protected void refreshControlButtons() {
		assert frame.isActive();
		boolean hasChanges = hasSideNotes(getTree(), getCurrentObject(), treeAtFrame.getUserChangesKey());
		applyButton.setEnabled(hasChanges);
		revertButton.setEnabled(hasChanges);
	}

}
