package com.framsticks.experiment;

import com.framsticks.communication.Address;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.dispatching.AbstractJoinable;
import com.framsticks.util.lang.Strings;

public abstract class SingleSimulatorProvider extends AbstractJoinable implements SimulatorProvider {


	@ParamAnnotation(id = "address")
	public void setAddressString(String address) {
		setAddress(new Address(address));
	}

	@ParamAnnotation(id = "address")
	public String getAddressString() {
		return Strings.toStringNullProof(getAddress(), "");
	}

	public abstract void setAddress(Address address);

	public abstract Address getAddress();

	@Override
	public String toString() {
		return "simulator connector to: " + Strings.toStringNullProof(getAddress(), "<null>");
	}

}
