package com.framsticks.experiment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.communication.Address;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.params.types.UniversalParam;
import com.framsticks.util.dispatching.FutureHandler;
import com.framsticks.util.dispatching.JoinableCollection;

@FramsClassAnnotation
public class SimulatorRange extends JoinableCollection<SimulatorProvider> implements SimulatorProvider {
	private static final Logger log = LogManager.getLogger(Experiment.class);


	protected List<String> hosts = new ArrayList<>();
	protected List<Integer> ports = new ArrayList<>();

	protected Iterator<Address> addresses;
	protected boolean run = true;

	@Override
	public String getName() {
		return "simulator range";
	}

	@Override
	public void provideSimulator(final SimulatorSpecification specification, final FutureHandler<Simulator> future) {
		if (addresses == null) {
			log.info("providing simulators from set: {} X {}", hosts, ports);

			List<Address> list = new ArrayList<Address>();
			for (String host : hosts) {
				for (Integer port : ports) {
					list.add(new Address(host, port));
				}
			}
			addresses = list.iterator();
		}

		if (!addresses.hasNext()) {
			future.pass(null);
			return;
		}
		Address address = addresses.next();
		SingleSimulatorProvider provider = (run ? new SimulatorRunner() : new SimulatorConnector());
		provider.setAddress(address);
		add(provider);
		provider.provideSimulator(specification, future);
	}

	/**
	 * @return the hosts
	 */
	@ParamAnnotation(paramType = UniversalParam.class)
	public List<String> getHosts() {
		return hosts;
	}

	/**
	 * @param hosts the hosts to set
	 */
	@ParamAnnotation
	public void setHosts(List<String> hosts) {
		this.hosts = hosts;
	}

	/**
	 * @return the ports
	 */
	@ParamAnnotation(paramType = UniversalParam.class)
	public List<Integer> getPorts() {
		return ports;
	}

	/**
	 * @param ports the ports to set
	 */
	@ParamAnnotation
	public void setPorts(List<Integer> ports) {
		this.ports = ports;
	}

	/**
	 * @return the run
	 */
	@ParamAnnotation
	public boolean getRun() {
		return run;
	}

	/**
	 * @param run the run to set
	 */
	@ParamAnnotation
	public void setRun(boolean run) {
		this.run = run;
	}
}
