package com.framsticks.dumping;

import com.framsticks.communication.File;
import com.framsticks.params.ListSource;
import com.framsticks.structure.Path;
import com.framsticks.structure.Tree;
import com.framsticks.structure.TreeOperations;
import com.framsticks.util.*;
import com.framsticks.util.dispatching.FutureHandler;
import com.framsticks.util.lang.Pair;
import com.framsticks.util.lang.Strings;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/**
 * @author Piotr Sniegowski
 */
public class LoadStream extends Stream {

	private final static Logger log = LogManager.getLogger(LoadStream.class.getName());

	protected final Tree tree;
	protected final Path mountPath;
	protected final BufferedReader stream;
	protected final FutureHandler<Path> future;
	protected final Stopwatch stopwatch = new Stopwatch();


	public LoadStream(Path mountPath, BufferedReader stream, Tree tree, FutureHandler<Path> future) {
		this.tree = tree;
		this.mountPath = mountPath;
		this.stream = stream;
		this.future = future;
	}

	public void load() {
		try {
			String line;
			Pair<String, String> query = null;
			List<File> files = null;
			List<String> content = null;
			//File file;
			while ((line = stream.readLine()) != null) {
				if (query == null) {
					query = Strings.splitIntoPair(line, ' ', "");
					files = new LinkedList<File>();
					log.trace("loading {}", line);
					continue;
				}
				if (content == null) {
					if (line.equals("file")) {
						content = new LinkedList<String>();
						continue;
					}
					if (line.equals("ok")) {
						if (query.first.equals("get")) {
							// Path path = null;
							throw new UnimplementedException().msg("rework load stream");
							// Path path = TreeOperations.createIfNeeded(tree, query.second);
							// TreeOperations.processFetchedValues(path, files);
						} else if (query.first.equals("info")) {
							assert files.size() == 1;
							TreeOperations.processFetchedInfo(tree, files.get(0));
						} else {
							assert false;
						}
						query = null;
						files = null;
						continue;
					}
					assert false;
					continue;
				}
				if (line.equals("eof")) {
					files.add(new File(query.second, new ListSource(content)));
					content = null;
					continue;
				}
				content.add(line);
			}
		} catch (IOException e) {
			log.error("failed to load: {}", e);
			future.handle(new FramsticksException().msg("failed to load stream").cause(e));
			return;
		}
		log.info("loaded in: {}", stopwatch);
		future.pass(Path.to(tree, mountPath.getTextual()));
	}


}
