package com.framsticks.communication.queries;

import com.framsticks.util.lang.Numbers;

/**
 * @author Piotr Sniegowski
 */
public class VersionRequest extends ProtocolRequest {
	protected Integer version;

	public VersionRequest() {
	}

	public VersionRequest version(Integer version) {
		this.version = version;
		return this;
	}

	@Override
	public String getCommand() {
		return "version";
	}

	@Override
	public CharSequence parseRest(CharSequence rest) {
		version = Numbers.parse(rest.toString(), Integer.class);
		return null;
	}

	@Override
	protected StringBuilder construct(StringBuilder buffer) {
		return buffer.append(version);
	}

}
