package com.framsticks.communication.queries;

import com.framsticks.util.lang.Pair;

/**
 * @author Piotr Sniegowski
 */
public class SetRequest extends ApplicationRequest {

	protected String field;
	protected String value;

	public SetRequest() {
	}

	public SetRequest field(String field) {
		this.field = field;
		return this;
	}

	public SetRequest value(String value) {
		this.value = value;
		return this;
	}

	@Override
	protected StringBuilder construct(StringBuilder buffer) {
		return quoteArgumentIfNeeded(super.construct(buffer).append(' ').append(field).append(' '), value);
	}

	@Override
	public String getCommand() {
		return "set";
	}


	@Override
	public CharSequence parseRest(CharSequence rest) {
		final Pair<CharSequence, CharSequence> fp = takeString(super.parseRest(rest));
		field = fp.first.toString();
		final Pair<CharSequence, CharSequence> vp = takeString(fp.second);
		value = vp.first.toString();

		return vp.second;
	}

	/**
	 * @return the field
	 */
	public String getField() {
		return field;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}
}
