package com.framsticks.communication.queries;

import com.framsticks.structure.Path;
import com.framsticks.util.lang.Pair;

/**
 * @author Piotr Sniegowski
 */
public class RegisterRequest extends ApplicationRequest {

	protected String actualPath;
	protected String eventName;

	public RegisterRequest register() {
		return this;
	}

	public String getCommand() {
		return "reg";
	}

	@Override
	public RegisterRequest path(String path) {
		super.path(path);
		Pair<String, String> p = Path.removeLastElement(path);
		actualPath = p.first;
		eventName = p.second;
		return this;
	}

	@Override
	public String getActualPath() {
		return actualPath;
	}

	public String getEventName() {
		return eventName;
	}

}
