package com.framsticks.communication.queries;

import com.framsticks.communication.File;
import com.framsticks.util.dispatching.FutureHandler;
import com.framsticks.util.lang.Strings;

public class NeedFile {

	protected final String suggestedName;
	protected final String description;
	protected final FutureHandler<File> future;

	/**
	 * @param suggestedName
	 * @param description
	 * @param future
	 */
	public NeedFile(String suggestedName, String description, FutureHandler<File> future) {
		this.suggestedName = suggestedName;
		this.description = description;
		this.future = future;
	}

	/**
	 * @return the suggestedName
	 */
	public String getSuggestedName() {
		return suggestedName;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @return the future
	 */
	public FutureHandler<File> getFuture() {
		return future;
	}

	@Override
	public String toString() {
		return Strings.toStringEmptyProof(suggestedName, "?") + " " + Strings.toStringEmptyProof(description, "?");
	}

}
