package com.framsticks.communication.queries;

import com.framsticks.util.Misc;
import com.framsticks.util.lang.Pair;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author Piotr Sniegowski
 */
public class CallRequest extends ApplicationRequest {

	protected final List<Object> arguments = new ArrayList<>();
	protected String procedure;

	public CallRequest addArguments(String arguments) {
		return this;
	}

	/**
	 * @return the arguments
	 */
	public List<Object> getArguments() {
		return arguments;
	}

	/**
	 * @return the procedure
	 */
	public String getProcedure() {
		return procedure;
	}

	/**
	 * @param arguments the arguments to set
	 */
	public CallRequest arguments(Collection<Object> arguments) {
		this.arguments.clear();
		this.arguments.addAll(arguments);
		return this;
	}

	public CallRequest argument(Object argument) {
		arguments.add(argument);
		return this;
	}

	public CallRequest procedure(String procedure) {
		this.procedure = procedure;
		return this;
	}

	@Override
	protected StringBuilder construct(StringBuilder buffer) {
		super.construct(buffer);
		Misc.throwIfNull(procedure);
		buffer.append(' ').append(procedure);
		for (Object arg : arguments) {
			buffer.append(' ');
			quoteArgumentIfNeeded(buffer, arg);
		}
		return buffer;
	}

	@Override
	public String getCommand() {
		return "call";
	}

	@Override
	public CharSequence parseRest(CharSequence rest) {
		rest = super.parseRest(rest);
		Pair<CharSequence, CharSequence> p = Misc.throwIfNull(takeIdentifier(rest));
		this.procedure = p.first.toString();
		while ((p = takeString(p.second)) != null) {
			arguments.add(p.first);
		}
		return null;
	}

}
