package com.framsticks.communication.queries;

import com.framsticks.communication.Request;
import com.framsticks.util.lang.Pair;
import com.framsticks.util.lang.Strings;


/**
 * @author Piotr Sniegowski
 */
public abstract class ApplicationRequest extends Request {

	protected String path;

	public ApplicationRequest path(String path) {
		Strings.assureNotEmpty(path);
		this.path = path;
		return this;
	}

	public String getPath() {
		return path;
	}

	public String getActualPath() {
		return path;
	}


	@Override
	protected StringBuilder construct(StringBuilder buffer) {
		return buffer.append(path);
	}

	@Override
	public CharSequence parseRest(CharSequence rest) {
		final Pair<CharSequence, CharSequence> p = takeIdentifier(rest);
		path = p.first.toString();
		return p.second;
	}

}
