package com.framsticks.communication;

import java.util.HashSet;
import java.util.Set;

import com.framsticks.util.lang.Pair;

public abstract class ManagedConnection extends Connection {

	public boolean requestIdEnabled = false;

	protected int protocolVersion = -1;

	protected Set<String> requestedFeatures = new HashSet<String>();

	public ManagedConnection() {
	}

	protected final Pair<Integer, CharSequence> takeRequestId(CharSequence line) {
		return Request.takeRequestId(requestIdEnabled, line);
	}

	/**
	 * Returns Query associated with query getId.
	 *
	 * @return Query associated with query getId.
	 */
	public int getProtocolVersion() {
		return protocolVersion;
	}

	@Override
	protected void joinableInterrupt() {
		protocolVersion = -1;
		super.joinableInterrupt();
	}

}
