package com.framsticks.communication;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.FramsticksException;

@FramsClassAnnotation
public class Address {

	private final static Pattern pattern = Pattern.compile("^([^:]*)(:([0-9]+))?$");

	protected final String hostName;
	protected final int port;

	/**
	 * @param hostName
	 * @param port
	 */
	public Address(String hostName, int port) {
		this.hostName = hostName;
		this.port = port;
	}

	public Address(String address) {
		Matcher matcher = pattern.matcher(address);
		if (!matcher.matches()) {
			throw new FramsticksException().msg("invalid address").arg("address", address);
		}
		hostName = matcher.group(1);
		port = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : 9009;
	}

	@Override
	public String toString() {
		return hostName + ":" + port;
	}

	/**
	 * @return the hostName
	 */
	@ParamAnnotation
	public String getHostName() {
		return hostName;
	}

	/**
	 * @return the port
	 */
	@ParamAnnotation
	public int getPort() {
		return port;
	}

}
