package com.framsticks.framclipse.editors.outline;

import java.util.List;

import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.framsticks.framclipse.editors.FramclipseEditor;
import com.framsticks.framclipse.internal.parser.ASTFunction;
import com.framsticks.framclipse.internal.parser.ASTGlobalDecl;
import com.framsticks.framclipse.internal.parser.ASTIdentList;
import com.framsticks.framclipse.internal.parser.Node;


public class FramclipseEditorOutlineContentProvider implements ITreeContentProvider
{
	private Node root;
	private FramclipseEditor editor;

	protected final static String FRAMCLIPSE_ELEM_POSITIONS = "__framclipse_elem_positions";
	protected IPositionUpdater positionUpdater = new DefaultPositionUpdater(FRAMCLIPSE_ELEM_POSITIONS);
	
	public FramclipseEditorOutlineContentProvider(FramclipseEditor framsEditor)
	{
		this.editor = framsEditor;
	}
	
	public Object[] getChildren(Object parentElement) {
		
		if(parentElement instanceof Node)
		{
			Node node = (Node)parentElement;
			
			if(node instanceof ASTFunction)
			{
				if(node.jjtGetNumChildren() > 1)
				{
					ASTIdentList params = (ASTIdentList) node.jjtGetChild(1);
					List<String> names = params.getIdents();
					
					Node[] children = new Node[names.size()];
					
					for(int l = 0; l < names.size(); ++l)
						children[l] = new IdentifierNode(names.get(l), "Parameter", node);
					
					return children;
				}
				return new Object[0];
			}
			if(node instanceof ASTGlobalDecl)
			{
				if(node.jjtGetNumChildren() > 0)
				{
					ASTIdentList params = (ASTIdentList) node.jjtGetChild(0);
					List<String> names = params.getIdents();
					
					Node[] children = new Node[names.size()];
					
					for(int l = 0; l < names.size(); ++l)
						children[l] = new IdentifierNode(names.get(l), "Variable", node);
					
					return children;
				}
				return new Object[0];
			}
			
			if(node.jjtGetNumChildren() > 0)
			{
				Node[] children = new Node[node.jjtGetNumChildren()];
				
				for(int k = 0; k < node.jjtGetNumChildren(); ++k)
					children[k] = node.jjtGetChild(k);
				
				return children;
			}
		}
		

		return new Object[0];
	}

	public Object getParent(Object element) {

		if(element instanceof Node)
		{
			return ((Node)element).jjtGetParent();
		}
		return null;
	}

	public boolean hasChildren(Object element) {
		
		if(element instanceof Node)
		{
			if(element instanceof ASTFunction)
			{
				return ((Node)element).jjtGetNumChildren() > 1;
			}
			
			return ((Node)element).jjtGetNumChildren() > 0;
		}
		
		return false;
	}

	public Object[] getElements(Object inputElement) {
		if (root == null)
			return new Object[0];
		if(root.jjtGetNumChildren() > 0)
		{
			Node[] children = new Node[root.jjtGetNumChildren()];
			
			for(int k = 0; k < root.jjtGetNumChildren(); ++k)
				children[k] = root.jjtGetChild(k);
			
			return children;
		}
		
		return new Object[0];
	}

	public void dispose() {
		// TODO Auto-generated method stub
		
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		if (oldInput != null)
		{
			IDocument document = editor.getDocumentProvider().getDocument(oldInput);
			if (document != null)
			{
				try
				{
					document.removePositionCategory(FRAMCLIPSE_ELEM_POSITIONS);
				}
				catch (BadPositionCategoryException x)
				{
				}
				document.removePositionUpdater(positionUpdater);
			}
		}
		
		root =  (Node) newInput;

		if (newInput != null)
		{
			IDocument document = editor.getDocumentProvider().getDocument(newInput);
			if (document != null)
			{
				document.addPositionCategory(FRAMCLIPSE_ELEM_POSITIONS);
				document.addPositionUpdater(positionUpdater);
				
			}
		}
	}

}
