/*
 *  geno_f4.h - f4 genetic operators.
 *
 *  f4genotype - f4 format genotype conversions for FramSticks
 *
 *  Copyright (C) 1999,2000  Adam Rotaru-Varga (adam_rotaru@yahoo.com)
 *  Copyright (C) 2001-2004  Maciej Komosinski
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef _GENO_F4_H_
#define _GENO_F4_H_

#include "f4_general.h"
#include "nonstd.h"
#include <stdio.h>
#include "geno_fx.h"
#include "param.h"


#define F4_ADD           0
#define F4_DEL           1
#define F4_MOD           2
#define F4_COUNT         3

#define F4_ADD_DIV       0
#define F4_ADD_CONN      1
#define F4_ADD_NEUPAR    2
#define F4_ADD_REP       3
#define F4_ADD_SIMP      4
#define F4_ADD_COUNT     5


class Geno_f4: public Geno_fx
{
public:
  Geno_f4();
  int validate(char *&);
  int checkValidity(const char *);
  int mutate(char *& g, float & chg,int &method);
  int crossOver(char *&g1, char *&g2, float& chg1, float& chg2);
  char* getSimplest() {return "X";};
  unsigned long style(const char *g, int pos);

  // mutation probabilities
  double prob[F4_COUNT],probadd[F4_ADD_COUNT];

protected:
  /* int MutateMany(char *& g, float & chg); // not used any more */
  int  ValidateRec(f4_node * geno, int retrycount) const;
  int  MutateOne(f4_node *& g,int &method) const;
  void linkNodeMakeRandom(f4_node * nn) const;
  void linkNodeChangeRandom(f4_node * nn) const;
  void nparNodeMakeRandom(f4_node * nn) const;
  void repeatNodeChangeRandom(f4_node * nn) const;
  int  MutateOneValid(f4_node * &g,int &method) const;
  int  CrossOverOne(f4_node *g1, f4_node *g2, float chg) const;
    // returns GENOPER_OK or GENOPER_OPFAIL
    // chg: fraction of parent1 genes in child (in g1) (parent2 has the rest)
};


#endif

