/*
 *  f4_orientmat.h - Extension of Orient with matrix multiplication.
 *
 *  f4genotype - f4 format genotype conversions for FramSticks
 *
 *  Copyright (C) 1999,2000  Adam Rotaru-Varga (adam_rotaru@yahoo.com)
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef _F4_ORIENTMAT_H_
#define _F4_ORIENTMAT_H_

#include "3d.h"

typedef enum {
   xOy, xOz, yOz
} XYZplanes;

class f4_OrientMat: public Orient 
{ 
 public:
  f4_OrientMat() : Orient() {};
  f4_OrientMat(const Orient & o) : Orient(o) {};
  /// matrix multiplication
  f4_OrientMat operator*(const Orient & M2);
  /// rotation matrix in a given cartesian plane
  f4_OrientMat(XYZplanes plane, float angle);
};

#endif
