/**
 *  conv_f4.h - f4 conversion functions.
 *
 *  f4genotype - f4 format genotype conversions for FramSticks
 *
 *  Copyright (C) 1999,2000  Adam Rotaru-Varga (adam_rotaru@yahoo.com)
 *  Copyright (C) 2001-2003  Maciej Komosinski
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef _CONV_F4_H_
#define _CONV_F4_H_

#include "model.h"
#include "modelparts.h"
#include "genoconv.h"
#include "f4_general.h"


// The f4->f0 converter
class GenoConv_F40: public GenoConverter
{
 public:
  GenoConv_F40();
  SString convert(SString &in, MultiMap * map);
};


// a test-only f4->f1 converter, approximates only
class GenoConv_F41_TestOnly: public GenoConverter
{
 public:
  GenoConv_F41_TestOnly();
  SString convert(SString &in, MultiMap * map);
};


// A Model descendant, which support build from an f4 genotype.
class f4_Model: public Model
{
 public:
  f4_Model();
  ~f4_Model();
  int      buildFromF4(SString &geno);
  void     toF1Geno(SString &out);       // output to f1 format, approximation
 private:
  f4_Cells * cells;
  int        buildModelRec(f4_Cell * ndad);
  /**
   * Get a cell which is a stick, by traversing dadlinks.
   */
  f4_Cell *  getStick(f4_Cell * C);
  int        error;
  int        errorpos;
};


#endif

