function Model() {
    this.groups = [];//tabliza z nazwami grup
    this._properties = {};//obiekt z propertisami
    this._context = "";
}

Model.prototype.setModel = function(data)
{
    var nodes = data[0].childNodes;

    for (var i = 0; i < nodes.length; i++) {
        if(nodes[i].nodeType == 3)
            continue;

        var node = $(nodes[i]);
        if (node.prop("tagName") == "GROUP")
            this.addGroup(node.attr("NAME"));
        else {
            this.addProperties(node);

        }
    }
    var keys = Object.keys(this._properties);
    this._context = keys[0];
}

Model.prototype.addGroup = function (name) {
    this.groups.push(name);
}

Model.prototype.showGroups = function () {
    console.log("Gropus");
    for (var obj in this.groups)
        console.log("\t", this.groups[obj]);
    console.log("\n");
}

Model.prototype.addProperties = function (data) {
    var properties = {};

    $(data).each(function () {
        $.each(this.attributes, function () {
            properties[this.name] = this.value;
        });

    });

    properties["VALUE"] = typeof(properties["DEF"]) === 'undefined' ? 0 : properties["DEF"];

    this._properties[properties["ID"]] = properties;
}

Model.prototype.showProperties = function () {
    console.log("Properites");
    for (var k in this._properties) {
        console.log(k);
        var prop = this._properties[k];
        for (var key in prop) {
            console.log("\t", key, prop[key]);
        }
        console.log("\n");
    }

}

Model.prototype.setValue = function(name, value)
{
    if(arguments.length == 0)   //use default value
        this._moveContext();
    else if(arguments.length == 1)   //use context
        this._setByContext(name);
    else if (arguments.length == 2){ //set by name
        this._setByName(name, value);
        this._moveContext();
    }
    else
        console.log("Error in function SetValue in Model");

}

Model.prototype._checkValue = function(name, value)
{
    var property = this._properties[name];
    if(property.hasOwnProperty("MIN") && property.hasOwnProperty("MAX"))
    {
        if(parseFloat(property["MIN"]) > parseFloat(value) || parseFloat(property["MAX"]) < parseFloat(value))
        {
            //throw new Error("Value for \"" + name + "\" has incorrect value");
        }
    }

    return true;
}

Model.prototype._setByName = function(name, value)
{
    if(this._checkValue(name, value)){
        this._properties[name]["VALUE"] = value;
        this._context = name;
    }

}

Model.prototype._setByContext = function(value)
{
    this._setByName(this._context, value);
    this._moveContext();
}

Model.prototype._moveContext = function()
{
    var keys = Object.keys(this._properties);
    var i = keys.indexOf(this._context);
    this._context = typeof(keys[i+1]) !== "undefined" ? keys[i+1] : this._context;
}