function NeuronDrawer(context) {
    this._scene = undefined;
    this._camera = undefined;
    this._renderer = undefined;
    this._canvasWidth = 400;
    this._canvasHeight = 400;
    this._containerContext = context;
    this._controls = undefined;
    this._showAxis = false;
    this._unknown_symbol=[1,4, 25,25, 75,25, 75,75, 25,75, 25,25];
    this._neuron_symbol=[1,4, 75,50, 25,0, 25,99, 75,50, 100,50];
    this._inputonly_symbol=[1,5, 25,40, 35,40, 45,50, 35,60, 25,60, 25,40];
    this._outputonly_symbol=[1,7, 75,50, 75,60, 55,60, 65,50, 55,40, 75,40, 75,50, 100,50];
    this._canvas = undefined;
    this._neurons = undefined;
}

NeuronDrawer.prototype.initialize = function () {


    //this._canvas = document.getElementById("containerNeuron");
    /*
    if (this._canvas.getContext){

        // use getContext to use the canvas for drawing
        var ctx = this._canvas.getContext('2d');

        var lastX=this._canvas.width/2, lastY=this._canvas.height/2;
        var dragStart,dragged;
        this._canvas.addEventListener('mousedown',function(evt){
            document.body.style.mozUserSelect = document.body.style.webkitUserSelect = document.body.style.userSelect = 'none';
            lastX = evt.offsetX || (evt.pageX - canvas.offsetLeft);
            lastY = evt.offsetY || (evt.pageY - canvas.offsetTop);
            dragStart = ctx.transformedPoint(lastX,lastY);
            dragged = false;
        },false);

        this._canvas.addEventListener('mousemove',function(evt){
            lastX = evt.offsetX || (evt.pageX - this._canvas.offsetLeft);
            lastY = evt.offsetY || (evt.pageY - this._canvas.offsetTop);
            dragged = true;
            if (dragStart){
                var pt = ctx.transformedPoint(lastX,lastY);
                ctx.translate(pt.x-dragStart.x,pt.y-dragStart.y);
                redraw();
            }
        },false);
        this._canvas.addEventListener('mouseup',function(evt){
            dragStart = null;
            if (!dragged) zoom(evt.shiftKey ? -1 : 1 );
        },false);

        // Filled triangle
        ctx.beginPath();
        ctx.moveTo(25,25);
        ctx.lineTo(105,25);
        ctx.lineTo(25,105);
        ctx.fill();

        // Stroked triangle
        ctx.beginPath();
        ctx.moveTo(125,125);
        ctx.lineTo(125,45);
        ctx.lineTo(45,125);
        ctx.closePath();
        ctx.stroke();

    }
    else
        alert("dupa");
    //this._debug();*/
}


NeuronDrawer.prototype.showPartAxis = function () {
    this._showAxis = true;
}

NeuronDrawer.prototype._createRenderer = function () {
    this._renderer = new THREE.CanvasRenderer();//WebGLRenderer({antialias: true});
    this._renderer.setClearColor(0xffffff, 1);
    this._renderer.setSize(this._canvasWidth, this._canvasHeight);
    //this._containerContext = $("#containerNeuron");
    this._containerContext.append(this._renderer.domElement);
}

NeuronDrawer.prototype._prepareCamera = function () {
    this._camera = new THREE.PerspectiveCamera(45, this._canvasWidth / this._canvasHeight, 1, 10000);
    this._camera.position.set(0, 0, 10);
    this._camera.lookAt(this._scene.position);
    this._scene.add(this._camera);
}

NeuronDrawer.prototype._addLight = function () {
    var directionalLight = new THREE.DirectionalLight(0xffffff);

    directionalLight.position = this._camera.position;
    directionalLight.intensity = 1;

    this._scene.add(directionalLight);
}

NeuronDrawer.prototype.initializeScene = function () {

    this._createRenderer();
    this._scene = new THREE.Scene();
    this._prepareCamera();
    this._addLight();
    this._controls = new THREE.TrackballControls(this._camera, this._renderer.domElement)
    this._debug();
}

NeuronDrawer.prototype.renderScene = function () {

    var self = this;
    requestAnimationFrame(
        function () {
            self.renderScene();
        });
    this._renderer.render(this._scene, this._camera);
    this._controls.update();

}

NeuronDrawer.prototype._debug = function () {
    this._scene.add(new THREE.AxisHelper(20));
}

NeuronDrawer.prototype.drawNeuron = function (x, y, scheme) {


    var obj = new THREE.Object3D();

    var material = new THREE.LineBasicMaterial({
        color: 0x0000ff
    });
    var position = 0;
    var noOfBlocks = 0;//number of "blocks" to draw
    var noOfLines = 0;//number of line to draw
    noOfBlocks = scheme[position++];
    for (var i = 0; i < noOfBlocks; i++) {
        noOfLines = scheme[position++];

        for (var j = 0; j < noOfLines; j++) {
            var geometry = new THREE.Geometry();
            geometry.vertices.push(new THREE.Vector3(scheme[position++] + x, scheme[position++] + y, 0));
            geometry.vertices.push(new THREE.Vector3(scheme[position++] + x, scheme[position++] + y, 0));
            position = position - 2; //get to last point in list
            var line = new THREE.Line(geometry, material);
            obj.add(line);
        }
        position = position + 2;//move to value which define number of lines to draw
    }

    var SCALE = 0.05;

    obj.scale.set(SCALE, SCALE, SCALE);
    obj.rotateX(Math.PI);//rotate 180 degree
    //obj.translateY(-5.5);
    this._scene.add(obj)
}

NeuronDrawer.prototype._getNumberOfInputs = function(number, connections){

    var counter = 0;

    for(var i = 0; i < connections.length; i++){
        if(connections[i].getDestination() == number)
            counter++;
    }

    return counter;
}

NeuronDrawer.prototype._getNumberOfOutputs = function(number, connections){
    var counter = 0;

    for(var i = 0; i < connections.length; i++){
        if(connections[i].getSource() == number)
            counter++;
    }

    return counter;
}

NeuronDrawer.prototype.drawConnection = function (id, neurons, connections, einfos) {

    var n2;

    for(var iw = 0; iw < this._getNumberOfInputs(id,connections); iw++)
    {
        n2 = neurons[iw];

        var yw = this._inputY(iw);
        var xw = yw / 4;
        this._drawLine()
    }
    
    /*var destination = connections[id].getDestination();
    var numberOfConnToDest = 0;
    var numberOfDrawenCon = 0;

    //check how many conenctions have the same destination
    for (var i = 0; i < connections.length; i++) {
        if (connections[i].getDestination() == destination)
            numberOfConnToDest++;
    }

    //check how many connections had been drawen
    for (var i = 0; i < id; i++) {
        if (connections[i].getDestination() == destination)
            numberOfDrawenCon++;
    }

    var positionY = (numberOfDrawenCon + 1) * 100 / (numberOfConnToDest + 1);
    var positionX = (numberOfDrawenCon + 1) * 10 / (numberOfConnToDest + 1);

    var x1 = einfos[connections[id].getDestination()].x;
    var y1 = einfos[connections[id].getDestination()].y;

    var x2 = einfos[connections[id].getSource()].x;
    var y2 = einfos[connections[id].getSource()].y;

    var material = new THREE.LineBasicMaterial({
        color: 0x0000ff
    });

    var SCALE = 0.05;

    var geometry = new THREE.Geometry();
    geometry.vertices.push(new THREE.Vector3(100 + x2 * 100, 10 + 50 + y2 * 100, 0));
    geometry.vertices.push(new THREE.Vector3(10 + 100 + x2 * 100, 10 + 50 + y2 * 100, 0));
    var line = new THREE.Line(geometry, material);
    line.scale.set(SCALE, SCALE, SCALE);
    this._scene.add(line);


    var geometry1 = new THREE.Geometry();
    geometry1.vertices.push(new THREE.Vector3(10 + positionX + x1 * 100, 10 + positionY + y1 * 100, 0));
    geometry1.vertices.push(new THREE.Vector3(10 + 25 + x1 * 100, 10 + positionY + y1 * 100, 0));
    var line1 = new THREE.Line(geometry1, material);

    line1.scale.set(SCALE, SCALE, SCALE);
    this._scene.add(line1);

    //bezposredni poprzednik - to koniec :)
    if (x1 == x2 + 1)//kazdy polozony w kolumnie po lewej ma jedna ukosna linie
    {
        var geometry = new THREE.Geometry();
        geometry.vertices.push(new THREE.Vector3(10 + positionX + (x1 * 100), 10 + positionY + y1 * 100, 0));
        geometry.vertices.push(new THREE.Vector3(110 + x2 * 100, 10 + 50 + y2 * 100, 0));
        var line = new THREE.Line(geometry, material);
        line.scale.set(SCALE, SCALE, SCALE);
        this._scene.add(line);
        return;
    }

    //pierwszy pionowy
    if (y1 >= y2) {
        var geometry = new THREE.Geometry();
        geometry.vertices.push(new THREE.Vector3(110 + (x2 * 100), 60 + y2 * 100, 0));
        geometry.vertices.push(new THREE.Vector3(110 + (x2 * 100), 105 + y2 * 100, 0));
        var line = new THREE.Line(geometry, material);
        line.scale.set(SCALE, SCALE, SCALE);
        this._scene.add(line);
        return;
    }

    else {
        var geometry = new THREE.Geometry();
        geometry.vertices.push(new THREE.Vector3(110 + (x2 * 100), 60 + y2 * 100, 0));
        geometry.vertices.push(new THREE.Vector3(110 + (x2 * 100), 15 + y2 * 100, 0));
        var line = new THREE.Line(geometry, material);
        line.scale.set(SCALE, SCALE, SCALE);
        this._scene.add(line);
        return;
    }


    //poziomy
    if (y1 >= y2) {
        var geometry = new THREE.Geometry();
        geometry.vertices.push(new THREE.Vector3(110 + (x2 * 100), 105 + y2 * 100, 0));
        geometry.vertices.push(new THREE.Vector3(10 + positionX + (x1 * 100), 105 + y2 * 100, 0));
        var line = new THREE.Line(geometry, material);
        line.scale.set(SCALE, SCALE, SCALE);
        this._scene.add(line);
        return;
        //g.drawLine((int) ((110 + (x2 * 100)) * zoom), (int) ((105 + y2 * 100) * zoom), (int) ((10 + polozenieX + (x1 * 100)) * zoom), (int) ((105 + y2 * 100) * zoom));
    }
    else {
        var geometry = new THREE.Geometry();
        geometry.vertices.push(new THREE.Vector3(110 + (x2 * 100), 15 + y2 * 100, 0));
        geometry.vertices.push(new THREE.Vector3(10 + positionX + (x1 * 100), 15 + y2 * 100, 0));
        var line = new THREE.Line(geometry, material);
        line.scale.set(SCALE, SCALE, SCALE);
        this._scene.add(line);
        return;
        //g.drawLine((int) ((110 + (x2 * 100)) * zoom), (int) ((15 + y2 * 100) * zoom), (int) ((10 + polozenieX + (x1 * 100)) * zoom), (int) ((15 + y2 * 100) * zoom));
    }


    //drugi pionowy
    if (y1 >= y2) {
        var geometry = new THREE.Geometry();
        geometry.vertices.push(new THREE.Vector3(10 + positionX + (x1 * 100), 10 + positionY + y1 * 100, 0));
        geometry.vertices.push(new THREE.Vector3(10 + positionX + (x1 * 100), 105 + y2 * 100, 0));
        var line = new THREE.Line(geometry, material);
        line.scale.set(SCALE, SCALE, SCALE);
        this._scene.add(line);
        return;
        //g.drawLine((int) ((10 + polozenieX + (x1 * 100)) * zoom), (int) ((10 + polozenieY + y1 * 100) * zoom), (int) ((10 + polozenieX + (x1 * 100)) * zoom), (int) ((105 + y2 * 100) * zoom));
    }
    else {
        var geometry = new THREE.Geometry();
        geometry.vertices.push(new THREE.Vector3(10 + positionX + (x1 * 100), 10 + positionY + y1 * 100, 0));
        geometry.vertices.push(new THREE.Vector3(10 + positionX + (x1 * 100), 15 + y2 * 100, 0));
        var line = new THREE.Line(geometry, material);
        line.scale.set(SCALE, SCALE, SCALE);
        this._scene.add(line);
        return;
        //g.drawLine((int) ((10 + polozenieX + (x1 * 100)) * zoom), (int) ((10 + polozenieY + y1 * 100) * zoom), (int) ((10 + polozenieX + (x1 * 100)) * zoom), (int) ((15 + y2 * 100) * zoom));
    }
*/
}

NeuronDrawer.prototype._inputY = function(number, connections){
    return (1 + number)*this._neurons[number].sizeY / ((this._getNumberOfInputs(number, connections)) + 1);
}

NeuronDrawer.prototype._drawLine = function(x1, y1, x2, y2){
    var geometry = new THREE.Geometry();
    geometry.vertices.push(new THREE.Vector3(x1, y1, 0));
    geometry.vertices.push(new THREE.Vector3(x2, y2, 0));

    var material = new THREE.LineBasicMaterial({
        color: 0x0000ff
    });

    var SCALE = 1;

    var line = new THREE.Line(geometry, material);
    line.scale.set(SCALE, SCALE, SCALE);
    this._scene.add(line);
}

NeuronDrawer.prototype._chooseSchema = function(number, neurons, connections, classes)
{
    var schema = this._unknown_symbol;
    var type = neurons[number].getSchemeID();

    if(type != undefined)
    {
        if(classes[type].getScheme().length != 0)
        {
            if(this._getNumberOfInputs(number, connections) == 0)
                schema = this._outputonly_symbol;
            else if (this._getNumberOfOutputs(number, connections) == 0)
                schema = this._inputonly_symbol;
            else
                schema = this._neuron_symbol;
        }
    }

    return schema;
}

NeuronDrawer.prototype._getSize = function(scheme)
{
    var neuron = {sizeX: 0, sizeY: 0};
    var position = 0;
    var noOfBlocks = 0;//number of "blocks" to draw
    var noOfLines = 0;//number of line to draw
    noOfBlocks = scheme[position++];
    for (var i = 0; i < noOfBlocks; i++) {
        noOfLines = scheme[position++];

        for (var j = 0; j < noOfLines; j++) {

            if(scheme[position] > neuron.sizeX)
                neuron.sizeX = scheme[position];
            position++;
            if(scheme[position] > neuron.sizeY)
                neuron.sizeY = scheme[position];
            position++;

            if(scheme[position] > neuron.sizeX)
                neuron.sizeX = scheme[position];
            position++;
            if(scheme[position] > neuron.sizeY)
                neuron.sizeY = scheme[position];
            position++;

            position = position - 2;
        }
        position = position + 2;//move to value which define number of lines to draw
    }
    return neuron;
}

NeuronDrawer.prototype.drawNetwork = function (neurons, connections, layouts, classes) {

    this._neurons = [];

    for (var i = 0; i < layouts.length; i++) {
        var scheme = undefined;

        scheme = this._chooseSchema(i,neurons, connections, classes)
        var neuronData = this._getSize(scheme);
        neuronData.scheme = scheme;
        this._neurons.push(neuronData);
        this.drawNeuron(layouts[i].x * 100  , -layouts[i].y * 100 , scheme);
    }

    //for (var i = 0; i < connections.length; i++)
    //    this.drawConnection(i, neurons, connections, einfos);
}


NeuronDrawer.prototype.debugTest = function () {

}

