function Block(number){
    this.id = number;
    this.elements = [];
    this.w = 1;
    this.h = 1;
    this.minx = 0;
    this.miny = 0;
    this.maxx = 0;
    this.maxy = 0;
    blocks[this.id] = this;

    this.map = [];
}

Block.prototype.freeMap = function(){
    if(this.map)
        this.map = null;
}

Block.prototype.needMap = function(){
    if(this.map)
        return;
    this.createMap();

}

Block.prototype.createMap = function(){
    this.freeMap();
    this.w = this.maxx - this.minx + 1;
    this.h = this.maxy - this.miny + 1;
    for(var i = 0; i < w*h; i++)
        this.map.push(0);

    for (var i = 0; i < this.elements.size(); i++)
    {
        var e = this.elements[i];
        this.map[this.w*(einfos[e].y - this.miny) + (einfos[e].x - this.minx)] = 1;
    }


}

Block.prototype.destroy = function()
{
    blocks[this.id] = 0;
    this.freeMap();
}

Block.prototype.addElement = function(number, x, y){

}