package com.framsticks.util.lang;


import org.testng.annotations.Test;

import com.framsticks.test.TestConfiguration;
import static org.fest.assertions.Assertions.*;

@Test
public class StringsTest extends TestConfiguration {

	@Test
	public void testStrings() {
		assertThat(Strings.splitIntoPair("test 2", ' ', null)).isEqualTo(Pair.make("test", "2"));
		assertThat(Strings.splitIntoPair("tes", ' ', "other")).isEqualTo(Pair.make("tes", "other"));
		assertThat(Strings.splitIntoPair("xx yy zz", ' ', null)).isEqualTo(Pair.make("xx", "yy zz"));
		assertThat(Strings.splitIntoPair(" empty", ' ', null)).isEqualTo(Pair.make("", "empty"));
	}

}
