package com.framsticks.gui;

import org.fest.swing.core.Robot;
import org.fest.swing.edt.FailOnThreadViolationRepaintManager;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.fixture.JButtonFixture;
import org.testng.annotations.Test;

import com.framsticks.test.MonitorBasedTest;
import static org.fest.assertions.Assertions.assertThat;
import static org.fest.swing.edt.GuiActionRunner.executeInEDT;
import static org.fest.swing.core.BasicRobot.robotWithNewAwtHierarchy;

@Test
public abstract class GuiTest extends MonitorBasedTest {

	protected static Robot robot;

	static {
		FailOnThreadViolationRepaintManager.install();
		assertThat(executeInEDT()).isTrue();

		robot = robotWithNewAwtHierarchy();
	}

	protected void waitForIdle() {
		robot.waitForIdle();
	}

	protected void clickButton(final JButtonFixture button) {

		// button.click();

		GuiActionRunner.execute(new GuiTask() {
			@Override
			protected void executeInEDT() throws Throwable {
				button.component().doClick();
			}
		});
	}
}
