package com.framsticks.communication;

import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import com.framsticks.communication.queries.CallRequest;
import com.framsticks.communication.queries.GetRequest;
import com.framsticks.communication.queries.InfoRequest;
import com.framsticks.communication.queries.RegisterRequest;
import com.framsticks.communication.queries.SetRequest;
import com.framsticks.communication.queries.UseRequest;
import com.framsticks.communication.queries.VersionRequest;
import com.framsticks.test.TestConfiguration;
import com.framsticks.util.lang.Pair;

import static org.fest.assertions.Assertions.*;

@Test
public class RequestTest extends TestConfiguration {

	@Test
	public void genericParsing() {
		assertThat(Request.takeIdentifier("first second")).isEqualTo(Pair.make("first", "second"));
		assertThat(Request.takeIdentifier(" first ")).isEqualTo(Pair.make("first", ""));

		assertThat(Request.takeString(" \"a long comment\" second")).isEqualTo(Pair.make("a long comment", "second"));
		assertThat(Request.takeString(" simple second")).isEqualTo(Pair.make("simple", "second"));

		assertThat(Request.takeRequestId(true, " 2 simple second")).isEqualTo(Pair.make(2, "simple second"));
		assertThat(Request.takeRequestId(true, " -3 simple")).isEqualTo(Pair.make(-3, "simple"));
	}

	@Test(dataProvider = "requests", dependsOnMethods = "genericParsing")
	public void parsingAndPrintingRequests(Class<? extends Request> requestClass, String line) {
		Pair<CharSequence, CharSequence> pair = Request.takeIdentifier(line);
		Request request = Request.parse(pair.first, pair.second);
		assertThat(request).isInstanceOf(requestClass);
		assertThat(request.stringRepresentation()).isEqualTo(line);
	}

	@DataProvider
	public Object[][] requests() {
		return new Object[][] {
			{ CallRequest.class, "call /object function first second \"thi rd\""},
			{ GetRequest.class, "get /test"},
			{ GetRequest.class, "get /test one_field"},
			{ GetRequest.class, "get /test first_field,second_field"},
			{ SetRequest.class, "set /test field value"},
			{ SetRequest.class, "set /test field \"value with spaces\""},
			{ RegisterRequest.class, "reg /test/field_changed"},
			{ VersionRequest.class, "version 4"},
			{ InfoRequest.class, "info /some/path"},
			{ UseRequest.class, "use request_id"}
		};
	}

}
