package com.framsticks.visualization;

import com.framsticks.util.io.Encoding;
import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.objectfile.ObjectFile;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.universe.PlatformGeometry;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;

import javax.media.j3d.*;
import javax.swing.*;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import java.awt.*;
import java.io.*;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

public class Viewer {

	private static Logger log = LogManager.getLogger(Viewer.class);

	Canvas3D canvas3d;
	SimpleUniverse universe;

	public Viewer() {
		super();

		init();
	}

	public BranchGroup createSceneGraph() {
		// Create the root of the branch graph
		BranchGroup objRoot = new BranchGroup();

		// Create a Transform group to scale all objects so they
		// appear in the scene.
		TransformGroup objScale = new TransformGroup();
		Transform3D t3d = new Transform3D();
		t3d.setScale(0.7);
		objScale.setTransform(t3d);
		objRoot.addChild(objScale);

		TransformGroup objTrans = new TransformGroup();
		objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		objScale.addChild(objTrans);

		String filename = "/visualization/models/cylinder.obj";
		int flags = ObjectFile.RESIZE;
		flags |= ObjectFile.TRIANGULATE;
		flags |= ObjectFile.STRIPIFY;
		double creaseAngle = 60.0;
		ObjectFile f = new ObjectFile(flags,
				(float) (creaseAngle * Math.PI / 180.0));
		Scene s = null;
		try {
			InputStream is = this.getClass().getResourceAsStream(filename);
			s = f.load(new InputStreamReader(is, Encoding.getDefaultCharset()));
		} catch (FileNotFoundException | ParsingErrorException | IncorrectFormatException e) {
			log.fatal("fatal error", e);
			return null;
		}

		objTrans.addChild(s.getSceneGroup());

		BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);

		Color3f bgColor = new Color3f(0.05f, 0.05f, 0.5f);
		Background bgNode = new Background(bgColor);
		bgNode.setApplicationBounds(bounds);
		objRoot.addChild(bgNode);

		return objRoot;
	}

	private void init() {

		JTextPane textPane = new JTextPane();
		textPane.setEditable(false);

		GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();

		// Create a Canvas3D using the preferred configuration
		canvas3d = new Canvas3D(config);

		// Create simple universe with view branch
		universe = new SimpleUniverse(canvas3d);
		BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);

		// add mouse behaviours to the ViewingPlatform
		ViewingPlatform viewingPlatform = universe.getViewingPlatform();

		PlatformGeometry platformGeometry = new PlatformGeometry();

		// Set up the ambient light
		Color3f ambientColor = new Color3f(0.1f, 0.1f, 0.1f);
		AmbientLight ambientLightNode = new AmbientLight(ambientColor);
		ambientLightNode.setInfluencingBounds(bounds);
		platformGeometry.addChild(ambientLightNode);

		// Set up the directional lights
		Color3f light1Color = new Color3f(1.0f, 1.0f, 0.9f);
		Vector3f light1Direction = new Vector3f(1.0f, 1.0f, 1.0f);
		Color3f light2Color = new Color3f(1.0f, 1.0f, 1.0f);
		Vector3f light2Direction = new Vector3f(-1.0f, -1.0f, -1.0f);

		DirectionalLight light1 = new DirectionalLight(light1Color,
				light1Direction);
		light1.setInfluencingBounds(bounds);
		platformGeometry.addChild(light1);

		DirectionalLight light2 = new DirectionalLight(light2Color,
				light2Direction);
		light2.setInfluencingBounds(bounds);
		platformGeometry.addChild(light2);

		viewingPlatform.setPlatformGeometry(platformGeometry);

		viewingPlatform.setNominalViewingTransform();

		// Ensure at least 5 msec per frame (i.e., < 200Hz)
		universe.getViewer().getView().setMinimumFrameCycleTime(5);

		BranchGroup scene = new BranchGroup();
		BranchGroup content = createSceneGraph();

		// canvas3d.addMouseListener(behaviour);
		TransformGroup transformGroup = new TransformGroup(new Transform3D());
		transformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		transformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		MouseRotate behaviour = new MouseRotate();
		behaviour.setTransformGroup(transformGroup);
		transformGroup.addChild(behaviour);
		// behaviour.addListener(canvas3d);
		// behaviour.initialize();
		behaviour.setSchedulingBounds(new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
		transformGroup.addChild(content);
		// transformGroup.addChild(behaviour);
		scene.addChild(transformGroup);

		universe.addBranchGraph(scene);
		canvas3d.startRenderer();
		Dimension d = new Dimension(500, 500);
		canvas3d.setMinimumSize(d);
		canvas3d.setSize(d);
	}

	public Component getViewComponent() {
		return canvas3d;
	}


}
