package com.framsticks.util.lang;

import java.lang.reflect.Field;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.util.lang.Delimeted;

public final class FlagsUtil {

	private final static Logger log = LogManager.getLogger(FlagsUtil.class);

	private FlagsUtil() {
	}

	public static String write(Class<?> flagsClass, int flags, String empty) {
		Delimeted<String> d = new Delimeted<String>("+", empty);
		try {
			for (Field f : flagsClass.getDeclaredFields()) {
				if (f.getType() != int.class) {
					continue;
				}
				if ((flags & f.getInt(null)) != 0) {
					d.append(f.getName());
				}
			}
		} catch (IllegalArgumentException | IllegalAccessException e) {
			e.printStackTrace();
		}
		return d.build();
	}

	public static Integer read(Class<?> flagsClass, String flags) {
		Integer allFlags = 0;
		String[] flagsSplitted = flags.split("\\+");
		for (String flag : flagsSplitted) {
			try {
				allFlags |= Integer.valueOf(flag);
			} catch (NumberFormatException ex) {
				try {
					Field field = flagsClass.getDeclaredField(flag.toUpperCase());
					allFlags |= Integer.parseInt(field.get(null).toString());
				} catch (SecurityException e) {
					log.warn("security exception was thrown while trying to read flag ({})", flag);
				} catch (NoSuchFieldException | IllegalArgumentException | IllegalAccessException e) {
					log.warn("selected flag is not known ({})", flag);
				}
			}
		}
		return allFlags;
	}
}
